@echo off
REM ============================================
REM   ONE-TIME SETUP - DnK Dairy Queen
REM   Run this ONCE to configure PowerShell
REM ============================================

title DnK DQ - One-Time Setup

echo.
echo ============================================================
echo   DnK Dairy Queen - One-Time PowerShell Setup
echo ============================================================
echo.
echo   This will configure PowerShell on this computer to allow
echo   the Store Selector GUI to run without prompts.
echo.
echo   You only need to run this ONCE per computer.
echo.
echo   Press any key to continue, or close this window to cancel.
echo ============================================================
echo.
pause >nul

echo.
echo Setting PowerShell execution policy...
echo.

REM Set execution policy to RemoteSigned for CurrentUser (no admin needed)
REM Using -Force to automatically answer "Yes to All"
powershell.exe -Command "Set-ExecutionPolicy RemoteSigned -Scope CurrentUser -Force"

if errorlevel 1 (
    echo.
    echo ============================================================
    echo   SETUP FAILED!
    echo ============================================================
    echo.
    echo   PowerShell execution policy could not be set.
    echo   This might happen if you don't have permission.
    echo.
    echo   Don't worry! You can still use the tool.
    echo   Just use "⭐ START HERE - CLICK ME.bat" instead.
    echo ============================================================
    echo.
    pause
    exit /b 1
)

echo.
echo ============================================================
echo   SETUP COMPLETE! ✓
echo ============================================================
echo.
echo   PowerShell is now configured on this computer.
echo.
echo   From now on, you can:
echo   • Double-click "⭐ START HERE - CLICK ME.bat" to run reports
echo   • No more security prompts!
echo.
echo   You don't need to run this setup again on this computer.
echo ============================================================
echo.
echo Press any key to close this window.
pause >nul
